<?php

$themename = "Theme Options";
$shortname = "plg";
$version = "1.0";
$alt_stylesheets = array('green', 'red', 'blue', 'teal', 'pink', 'grey', 'orange');
$alt_backgrounds = array('blue', 'midnight', 'red', 'teal', 'pink', 'purple', 'brown', 'black', 'maroon', 'green', 'plain white');
$alt_contact_imgs = array('red-female', 'red-male', 'blue-male','blue-female');

// Create theme options
global $options;
$options = array (

array( "name" => "General",
 "type" => "section"),

array( "type" => "open"),

array( "name" => "Color Scheme",
 "desc" => "Select a color scheme for the theme.",
 "id" => $shortname."_alt_stylesheet",
 "type" => "select",
 "options" => $alt_stylesheets,
 "std" => "green"),
 
array( "name" => "Background Image",
 "desc" => "Select a background image for the theme.",
 "id" => $shortname."_alt_background",
 "type" => "select",
 "options" => $alt_backgrounds,
 "std" => ""),
 
array( "name" => "Sidebar Contact Image",
 "desc" => "Select color for the sidebar image for the theme.",
 "id" => $shortname."_sidebar_contact_img",
 "type" => "select",
 "options" => $alt_contact_imgs,
 "std" => ""),
 
array( "name" => "Hide Sidebar Contact Image",
 "desc" => "Tick the box to hide sidebar contact image.",
 "id" => $shortname."_sidebar_contact_img_show",
 "type" => "checkbox",
 "std" => "on"),

array( "name" => "Top Bar Text",
 "desc" => "Insert text to be displayed at the top left of each page.",
 "id" => $shortname."_top_bar_text",
 "type" => "text",
 "std" => ""),

array( "name" => "Header Image",
 "desc" => "Upload a new header image or insert the path to the image. When the image has uploaded, select 'Full size' and click 'insert into post'. Header dimensions must be 935px x 198px.",
 "id" => $shortname."_header_image",
 "type" => "img-upload",
 "std" => ""),

array( "name" => "Show Header Image",
 "desc" => "Tick the box to show the header image",
 "id" => $shortname."_header_image_on",
 "type" => "checkbox",
 "std" => "on"),

array( "type" => "close"),

array( "name" => "Form Settings",
 "type" => "section"),

array( "type" => "open"),

array( "name" => "Email Address",
 "desc" => "Please insert your email address that leads and Web site emails will be submitted to.",
 "id" => $shortname."_email_address",
 "type" => "text",
 "std" => ""),

array( "name" => "Optional CC Email Address",
 "desc" => "Please insert a second email address that leads and Web site emails will be copied to.",
 "id" => $shortname."_ccemail_address",
 "type" => "text",
 "std" => ""),

array( "name" => "Phone Number",
 "desc" => "Insert phone number to display it in the header and sidebar. Leaving it blank will keep the phone number text suppressed",
 "id" => $shortname."_phone_number",
 "type" => "text",
 "std" => ""),

array( "name" => "Contact Form Heading",
 "desc" => "Enter the phrase that you want in the heading of the form.  By default, this area will display Get an Instant Quote! unless you adjust it in this field.",
 "id" => $shortname."_form_heading",
 "type" => "text",
 "std" => ""),

array( "name" => "Disable Additional Field (Project)",
 "desc" => "Tick the box to disable the additional input (called Project by default) from appearing in the form on home page.",
 "id" => $shortname."_form_project",
 "type" => "checkbox",
 "std" => "on"),

array( "name" => "Additional Form Field Name",
 "desc" => "Enter the title of the additional field on the contact form.  By default, this area will display Your Project unless you adjust it in this field.",
 "id" => $shortname."_form_add",
 "type" => "text",
 "std" => "Your Project"),

array( "name" => "Disable Message Box",
 "desc" => "Tick the box to disable the free-form message box from appearing in the form on home page.",
 "id" => $shortname."_form_message",
 "type" => "checkbox",
 "std" => "on"),

array( "type" => "close"),

array( "name" => "Video Options",
 "type" => "section"),

array( "type" => "open"),

array( "name" => "Embed Video",
 "desc" => "Insert YouTube video id (the 11-character code right after http://www.youtube.com/watch?v=). Leaving it blank will supress the video area.",
 "id" => $shortname."_video",
 "type" => "text",
 "std" => ""),

array( "name" => "Text Above Video",
 "desc" => "Insert text to display above the video on the home page.<br/> You may include HTML.",
 "id" => $shortname."_video_text",
 "type" => "textarea",
 "std" => ""),

array( "name" => "Autoplay Video",
 "desc" => "Tick the box to autoplay the video on the homepage",
 "id" => $shortname."_autoplay",
 "type" => "checkbox",
 "std" => "on"),

array( "name" => "Hide Share Options",
 "desc" => "Tick the box to hide share options underneath the video",
 "id" => $shortname."_share",
 "type" => "checkbox",
 "std" => "on"),

array( "name" => "Hide Email in Share Options",
 "desc" => "Tick the box to hide only the email icon in the share options underneath the video",
 "id" => $shortname."_share_email",
 "type" => "checkbox",
 "std" => "on"),
 
array( "type" => "close"),

array( "name" => "Bullet List Below Video",
 "type" => "section"),

array( "type" => "open"),

array( "name" => "List Item #1",
 "desc" => "Insert the first bullet point below the video on the home page.  Leaving it blank will suppress it from appearing.",
 "id" => $shortname."_list_1",
 "type" => "text",
 "std" => ""),

array( "name" => "List Item #2",
 "desc" => "Insert the second bullet point below the video on the home page.  Leaving it blank will suppress it from appearing.",
 "id" => $shortname."_list_2",
 "type" => "text",
 "std" => ""),

array( "name" => "List Item #3",
 "desc" => "Insert the third bullet point below the video on the home page.  Leaving it blank will suppress it from appearing.",
 "id" => $shortname."_list_3",
 "type" => "text",
 "std" => ""),

array( "name" => "List Item #4",
 "desc" => "Insert the fourth bullet point below the video on the home page.  Leaving it blank will suppress it from appearing.",
 "id" => $shortname."_list_4",
 "type" => "text",
 "std" => ""),

array( "name" => "List Item #5",
 "desc" => "Insert the fifth bullet point below the video on the home page.  Leaving it blank will suppress it from appearing.",
 "id" => $shortname."_list_5",
 "type" => "text",
 "std" => ""),

array( "name" => "List Item #6",
 "desc" => "Insert the sixth bullet point below the video on the home page.  Leaving it blank will suppress it from appearing.",
 "id" => $shortname."_list_6",
 "type" => "text",
 "std" => ""),

array( "name" => "List Item #7",
 "desc" => "Insert the seventh bullet point below the video on the home page.  Leaving it blank will suppress it from appearing.",
 "id" => $shortname."_list_7",
 "type" => "text",
 "std" => ""),

array( "name" => "List Item #8",
 "desc" => "Insert the eighth bullet point below the video on the home page.  Leaving it blank will suppress it from appearing.",
 "id" => $shortname."_list_8",
 "type" => "text",
 "std" => ""),

array( "name" => "List Item #9",
 "desc" => "Insert the ninth bullet point below the video on the home page.  Leaving it blank will suppress it from appearing.",
 "id" => $shortname."_list_9",
 "type" => "text",
 "std" => ""),

array( "name" => "List Item #10",
 "desc" => "Insert the tenth bullet point below the video on the home page.  Leaving it blank will suppress it from appearing.",
 "id" => $shortname."_list_10",
 "type" => "text",
 "std" => ""),

array( "type" => "close"),

array( "name" => "Social Networking",
 "type" => "section"),

array( "type" => "open"),

array( "name" => "Facebook Page",
 "desc" => "Link to your Facebook page, <strong>with http://</strong>. It will be shown in below the video. Leaving it blank will keep the Facebook icon suppressed.",
 "id" => $shortname."_facebook_id",
 "type" => "text",
 "std" => ""),
 
array( "name" => "Twitter ID",
 "desc" => "Your Twitter user name, please. It will be shown below the video. Leaving it blank will keep the Twitter icon supressed.",
 "id" => $shortname."_twitter_id",
 "type" => "text",
 "std" => ""),

array( "name" => "Hide Social Option Under Sidebar",
 "desc" => "Tick the box to hide the social options at the bottom of the sidebar",
 "id" => $shortname."_social_side",
 "type" => "checkbox",
 "std" => "on"),
 
array( "type" => "close"),

array( "name" => "Advanced Options",
 "type" => "section"),

array( "type" => "open"),

array( "name" => "Hide Branding Images",
 "desc" => "If you wish to hide the branding images on this theme, please tick this box.",
 "id" => $shortname."_branding_show",
 "type" => "checkbox",
 "std" => "on"),

array( "name" => "Hide Meta Data on Blog Posts",
 "desc" => "If you wish to hide the meta data on posts, such as the categories, comments and tags, please tick this box.",
 "id" => $shortname."_blog_meta",
 "type" => "checkbox",
 "std" => "on"),

array( "name" => "Move Sidebar Contact Image Up Higher (Below Form)",
 "desc" => "If you wish to move the Sidebar Contact Image (with the picture of the person with the headset and the phone number in it) higher to be placed above the widgets, please tick this box.",
 "id" => $shortname."_contactimg_move",
 "type" => "checkbox",
 "std" => "on"),

array( "name" => "Customize Email in Share Options",
 "desc" => "By default, your main email address shows in this section as the email to send messages to - if you want to change that email address to a different one, please enter it here. Leaving it blank will keep your main email address in this section unless you supress this option from appearing at all in the following option.",
 "id" => $shortname."_email_override",
 "type" => "text",
 "std" => ""),

array( "type" => "close"),

array( "name" => "Footer",
 "type" => "section"),

array( "type" => "open"),

array( "name" => "Copyright Text",
 "desc" => "Paste your copyright statements here. Leaving it blank will result in a default copyright setting.",
 "id" => $shortname."_copyright",
 "type" => "textarea",
 "std" => ""),

array( "name" => "Analytics/Tracking Code",
 "desc" => "You can paste your Google Analytics or other website tracking code in this box. This will be automatically added to the footer.",
 "id" => $shortname."_analytics_code",
 "type" => "textarea",
 "std" => ""),

array( "type" => "close"),

);

function plg_add_admin() {

    global $themename, $shortname, $options;

	if ( isset ( $_GET['page'] ) && ( $_GET['page'] == basename(__FILE__) ) ) {

		if ( isset ($_REQUEST['action']) && ( 'save' == $_REQUEST['action'] ) ){

			foreach ( $options as $value ) {
				if ( array_key_exists('id', $value) ) {
					if ( isset( $_REQUEST[ $value['id'] ] ) ) {
						update_option( $value['id'], $_REQUEST[ $value['id'] ]  );
					}
					else {
						delete_option( $value['id'] );
					}
				}
			}
		header("Location: admin.php?page=".basename(__FILE__)."&saved=true");
		}
		else if ( isset ($_REQUEST['action']) && ( 'reset' == $_REQUEST['action'] ) ) {
			foreach ($options as $value) {
				if ( array_key_exists('id', $value) ) {
					delete_option( $value['id'] );
				}
			}
		header("Location: admin.php?page=".basename(__FILE__)."&reset=true");
		}
	}

add_theme_page($themename, $themename, 'administrator', basename(__FILE__), 'plg_admin');
add_submenu_page(basename(__FILE__), $themename . ' Options', 'Theme Options', 'administrator',  basename(__FILE__),'plg_admin'); // Default

add_menu_page('Rockstar Options', 'Rockstar Options', 9, basename(__FILE__), 'plg_admin');

}

function plg_add_init() {

$file_dir=get_bloginfo('template_directory');
wp_enqueue_style("plgCss", $file_dir."/functions/theme-options.css", false, "1.0", "all");
wp_enqueue_script("plgScript", $file_dir."/functions/theme-options.js", false, "1.0");

}

function plg_admin() {

    global $themename, $shortname, $version, $options;
	$i=0;

	if ( isset ($_REQUEST['saved']) && ($_REQUEST['saved'] ) )echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings saved.</strong></p></div>';
	if ( isset ($_REQUEST['reset']) && ($_REQUEST['reset'] ) ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings reset.</strong></p></div>';

if ($_POST['key']!='') {
   if (get_option('key')!=$_POST['key']) {
      update_option('key','');
      $key=$_POST['key'];
      update_option('key',$key);
   } else {
      $key=$_POST['key'];
      update_option('key',$key);
   }
} else {
   $key=get_option('key');
}

$adminemail=get_bloginfo('admin_email');
$root=get_bloginfo('url');

$url = 'http://www.localheaders.com/validate.php?id='.$key.'&domain='.$root.'&email='.$adminemail;
$file=wp_remote_fopen($url);

$items=explode(":",$file);

if ($items[0]=='1') {

?>

<div class="wrap ">
<div class="options_wrap">

<?php 
if (get_option('plg_branding_show') != 'true') { 
?>
<img src="<?php echo get_stylesheet_directory_uri() ; ?>/functions/siteheader.png" width=500 height=149>
<?php
}
?>

<h2 class="settings-title"><?php echo 'RockStar Local Lead Theme: '.$themename; ?></h2>

<h3 style=" display: block; line-height: 30px; font-size: 24px; font-family: georgia; font-style: oblique; font-weight: normal; color: #e52b69; margin: 0px;"><?php echo $items[1]; ?></h3>

<p>Click on any of the sections below to expand the options for that section.</p>
<form method="post">

<?php foreach ($options as $value) {
switch ( $value['type'] ) {
case "section":
?>
	<div class="section_wrap">
	<h3 class="section_title"><?php echo $value['name']; ?></h3>
	<div class="section_body">

<?php
break;
case 'img-upload':
?>

	<div class="options_input options_text">
		<div class="options_desc"><?php echo $value['desc']; ?></div>
		<span class="labels"><label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label></span>
		<input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="text" value="<?php if ( get_option( $value['id'] ) != "") { echo stripslashes(get_option( $value['id'])  ); } else { echo $value['std']; } ?>" /><input id="upload_image_button" type="button" value="Upload Image" />
	</div>

<?php
break;
case 'text':
?>

	<div class="options_input options_text">
		<div class="options_desc"><?php echo $value['desc']; ?></div>
		<span class="labels"><label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label></span>
		<input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_option( $value['id'] ) != "") { echo stripslashes(get_option( $value['id'])  ); } else { echo $value['std']; } ?>" />
	</div>

<?php
break;
case 'textarea':
?>
	<div class="options_input options_textarea">
		<div class="options_desc"><?php echo $value['desc']; ?></div>
		<span class="labels"><label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label></span>
		<textarea name="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" cols="" rows=""><?php if ( get_option( $value['id'] ) != "") { echo stripslashes(get_option( $value['id']) ); } else { echo $value['std']; } ?></textarea>
	</div>

<?php
break;
case 'select':
?>
	<div class="options_input options_select">
		<div class="options_desc"><?php echo $value['desc']; ?></div>
		<span class="labels"><label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label></span>
		<select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
		<?php foreach ($value['options'] as $option) { ?>
				<option <?php if (get_option( $value['id'] ) == $option) { echo 'selected="selected"'; } ?>><?php echo $option; ?></option><?php } ?>
		</select>
	</div>

<?php
break;
case "radio":
?>
	<div class="options_input options_select">
		<div class="options_desc"><?php echo $value['desc']; ?></div>
		<span class="labels"><label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label></span>
		  <?php foreach ($value['options'] as $key=>$option) {
			$radio_setting = get_option($value['id']);
			if($radio_setting != ''){
				if ($key == get_option($value['id']) ) {
					$checked = "checked=\"checked\"";
					} else {
						$checked = "";
					}
			}else{
				if($key == $value['std']){
					$checked = "checked=\"checked\"";
				}else{
					$checked = "";
				}
			}?>
			<input type="radio" name="<?php echo $value['id']; ?>" value="<?php echo $key; ?>" <?php echo $checked; ?> /><?php echo $option; ?><br />
			<?php } ?>
	</div>

<?php
break;
case "checkbox":
?>
	<div class="options_input options_checkbox">
		<div class="options_desc"><?php echo $value['desc']; ?></div>
		<?php if(get_option($value['id'])){ $checked = "checked=\"checked\""; }else{ $checked = "";} ?>
		<input type="checkbox" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="true" <?php echo $checked; ?> />
		<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
	 </div>

<?php
break;
case "close":
$i++;
?>
<span class="submit"><input name="save<?php echo $i; ?>" type="submit" value="Save Changes" /></span>

</div><!--#section_body-->
</div><!--#section_wrap-->

<?php break;
}
}
?>

<input type="hidden" name="action" value="save" />
<span class="submit">
<input name="save" type="submit" value="Save All Changes" />
</span>
</form>

<br/>
<br class="clear" />

<p><a href="<?php echo get_bloginfo('wpurl'); ?>/wp-admin/options-general.php?page=__getthere">Jump to Mobile Site Options</a></p>

<br />

<?php 
if (get_option('plg_branding_show') != 'true') { 
?>
<p><a href="http://www.rockstarleadtheme.com/upgrade/"><img src="http://image-ads.s3.amazonaws.com/rs-local-lead-theme.png" border=0></a></p>
<?php } ?>
<small>Support is just a <a href="http://www.rockstarhelp.com" target="_blank">click away</a> ... </small>

</div><!--#options-wrap-->

</div><!--#wrap-->

<?php

} else {

if (get_option('key')=='') {
   $message='Please enter your key below:';
} else {
   $message=$items[1];
}

?>

<div class="wrap ">
<div class="options_wrap">
<img src="<?php echo get_stylesheet_directory_uri() ; ?>/functions/siteheader.png" width=500 height=149>

<h2 class="settings-title"><?php echo 'RockStar Local Lead Theme: '.$themename; ?></h2>

<h3 style=" display: block; line-height: 30px; font-size: 24px; font-family: georgia; font-style: oblique; font-weight: normal; color: #e52b69; margin: 0px;"><?php echo $message; ?></h3>

<form method="post">
<ul style="margin:0px;">

	<li style="background: #fcfcfc; border: 1px solid #cccccc; border-radius: 5px; padding: 8px; width: 55%; margin: 10px 0px;"><b style="display: block; color: #555555;">Enter Your Key</b><small style="display: block; color: #555555; color: #999999; padding: 0px 0px 2px 0px; margin: 0px 0px 8px 0px; border-bottom: 1px dotted #cccccc; text-transform: uppercase; font-size: 9px;">Enter in the key that you received when you purchased this theme.  If you need assistance, please reach out to us at rockstarhelp.com.</small><input type="text" NAME="key"></li>

	<input style="width: 300px; color: #555;" style="margin-bottom: 15px;" type="submit" class="button" value="Save Settings" />

</ul>
</form>

<p><img src="http://image-ads.s3.amazonaws.com/rs-local-lead-theme.png"></p>
<small>Support is just a <a href="http://www.rockstarhelp.com" target="_blank">click away</a> ... </small>
</div>
</div>

<?php

} 

} 
add_action('admin_init', 'plg_add_init');
add_action('admin_menu' , 'plg_add_admin');
