<?php
/**
 * Template Name: Paper Template
 */

if (!defined("ABSPATH")) { die("Use index.html for regular HTML pages, or install this as a WordPress plugin."); }
$cssInclude = plugins_url("css/papertemplate.css", __FILE__);

if (file_exists($_SERVER["DOCUMENT_ROOT"].'/global.header.php')) {
   require_once($_SERVER["DOCUMENT_ROOT"].'/global.header.php');
}
?>
<html>
<head>
<title><?php the_title(); ?></title>

<!-- Main stylesheet for the layout -->
<?php
wp_register_style('papertemplate-style', $cssInclude);
wp_enqueue_style('papertemplate-style' );
wp_head();
?>
</head>

<body>

<div align="center">

   
   <div id="contentContainer">
      <div id="contentTop"></div>

      <div id="content">
<?php
if ( have_posts() ) : while ( have_posts() ) : the_post();
the_content();
endwhile; endif;
?>
</div> <!-- end of content layer -->

      <div id="contentBottom"></div>

   </div> <!-- end of contentContainer layer -->

<?php require(dirname(__FILE__) . '/papertemplate-navigation.php'); ?>

</div> <!-- end of centered layer -->
<?php wp_footer(); ?>

</body>
</html>
<?php
if (file_exists($_SERVER["DOCUMENT_ROOT"].'/global.footer.php')) {
   require_once($_SERVER["DOCUMENT_ROOT"].'/global.footer.php');
}
?>