var p1cm_in_action = false;

jQuery( document ).ready(function( $ ) {
	$( '#add-proxy' ).click(function() {
		var ip = $( '#proxy-ip' ).val();
		var port = $( '#proxy-port' ).val();
		var username = $( '#proxy-username' ).val();
		var password = $( '#proxy-password' ).val();
		var id = p1cm_proxy_id( ip );
		
		p1cm_proxy_action( id, ip, port, username, password, 'Adding' );
		
		$( '#proxy-ip' ).val( '' );
		$( '#proxy-port' ).val( '' );
		$( '#proxy-username' ).val( '' );
		$( '#proxy-password' ).val( '' );
		
		$( '#add-proxy-modal' ).modal( 'hide' );
	});
	
	$( '#bulk-add-proxy' ).click(function() {
		var lines = $( '#proxy-descriptions' ).val().split( "\n" );
		for ( index in lines ) {
			var line = $.trim( lines[ index ] );
			if ( line == '' ) {
				continue;
			}
			var parts = line.split( ":" );
			var username = parts[ 2 ];
			if ( username === undefined ) {
				username = '';
			}
			var password = parts[ 3 ];
			if ( password === undefined ) {
				password = '';
			}
			p1cm_proxy_action( p1cm_proxy_id( parts[ 0 ] ), parts[ 0 ], parts[ 1 ], username, password, 'Adding' );
		}
		
		$( '#proxy-descriptions' ).val( '' );
		$( '#bulk-add-proxy-modal' ).modal( 'hide' );
	});
});

jQuery( document ).on( 'click', '.delete-proxy', function() {
	var $proxy_row = jQuery( this ).closest( 'tr' );

	p1cm_proxy_action(
		$proxy_row.attr( 'data-proxy-id' ),
		$proxy_row.find( '.proxy-ip' ).text(),
		$proxy_row.find( '.proxy-port' ).text(),
		$proxy_row.find( '.proxy-username' ).text(),
		$proxy_row.find( '.proxy-password' ).text(),
		'Deleting'
	);
	
	$proxy_row.remove();
});

jQuery( document ).on( 'click', '.test-proxy', function() {
	var $proxy_row = jQuery( this ).closest( 'tr' );

	p1cm_proxy_action(
		$proxy_row.attr( 'data-proxy-id' ),
		$proxy_row.find( '.proxy-ip' ).text(),
		$proxy_row.find( '.proxy-port' ).text(),
		$proxy_row.find( '.proxy-username' ).text(),
		$proxy_row.find( '.proxy-password' ).text(),
		'Testing'
	);

	$proxy_row.remove();
});

function add_proxy( id, active, ip, port, username, password ) {
	if ( active ) {
		active_class = 'active-proxy';
	} else {
		active_class = 'inactive-proxy';
	}
	
	$proxy_row = jQuery( '<tr data-proxy-id="' + id + '" class="' + active_class + '">'
		+ '<td class="proxy-ip">' + ip + '</td>'
		+ '<td class="proxy-port">' + port + '</td>'
		+ '<td class="proxy-username">' + username + '</td>'
		+ '<td class="proxy-password">' + password + '</td>'
		+ '<td><div class="btn-group">'
			+ '<span class="glyphicon glyphicon-trash delete-proxy"></span>'
			+ '<span class="glyphicon glyphicon-refresh test-proxy"></span>'
		+ '</div></td>' 
		+ '</tr>' );
	
	if ( active ) {
		jQuery( '#active-proxies' ).append( $proxy_row );
	} else {
		jQuery( '#inactive-proxies' ).append( $proxy_row );
	}
}

function p1cm_proxy_id( ip ) {
	return 'id' + ip.replace( '.', '-' );
}

function p1cm_proxy_action( id, ip, port, username, password, action ) {
	var $action_label = jQuery( '<span class="label">' + action + '</span>' );
	
	if ( action == 'Adding' ) {
		$action_label.addClass( 'label-success' );
	} else if ( action == 'Deleting' ) {
		$action_label.addClass( 'label-danger' );
	} else if ( action == 'Testing' ) {
		$action_label.addClass( 'label-warning' );
	}	
	
	$action_row = jQuery( '<tr data-proxy-id="' + id + '">'
		+ '<td class="proxy-ip">' + ip + '</td>'
		+ '<td class="proxy-port">' + port + '</td>'
		+ '<td class="proxy-username">' + username + '</td>'
		+ '<td class="proxy-password">' + password + '</td>'
		+ '<td class="proxy-action" data-proxy-action="' + action + '"></td>' 
		+ '</tr>' );
	
	$action_row.find( '.proxy-action' ).append( $action_label );
	
	jQuery( '#proxy_actions' ).append( $action_row );
	
	if ( ! p1cm_in_action ) {
		p1cm_in_action = true;
		p1cm_run_action( $action_row );
	}
}

function p1cm_run_action( $action_row ) {
	var $action_cell = $action_row.find( '.proxy-action' );
	var action = $action_cell.attr( 'data-proxy-action' );
	var data = {
		id : $action_row.attr( 'data-proxy-id' ),
		ip : $action_row.find( '.proxy-ip' ).text(),
		port : $action_row.find( '.proxy-port' ).text(),
		username : $action_row.find( '.proxy-username' ).text(),
		password : $action_row.find( '.proxy-password' ).text(),
	};
	
	var callback = function() {
		$next_action_row = $action_row.next();
		$action_row.remove();
		if ( $next_action_row.size() == 0 ) {
			p1cm_in_action = false;
		} else {
			p1cm_run_action( $next_action_row );
		}
	};
	
	$action_cell.append( jQuery( '#p1cm-loading' ).clone().removeClass( 'hide' ) );
	
	if ( action == 'Adding' ) {
		p1cm_action_add( data, callback );
	} else if ( action == 'Testing' ) {
		p1cm_action_test( data, callback );
	} else if ( action == 'Deleting' ) {
		p1cm_action_delete( data, callback );
	}
}

function p1cm_action_add( data, callback ) {
	data.action = 'p1cm-proxies-add-proxy';
	jQuery.post( ajaxurl, data, function( response ) {
		var data = jQuery.parseJSON( response );
		add_proxy( data.id, data.active, data.ip, data.port, data.username, data.password );
		callback();
	});
}

function p1cm_action_delete( data, callback ) {
	data.action= 'p1cm-proxies-delete-proxy';
	
	jQuery.post( ajaxurl, data, function( response ) {
		callback();
	});
}

function p1cm_action_test( data, callback ) {
	data.action = 'p1cm-proxies-test-proxy';
	
	jQuery.post( ajaxurl, data, function( response ) {
		var data = jQuery.parseJSON( response );
		add_proxy( data.id, data.active, data.ip, data.port, data.username, data.password );
		callback();
	});
}
