<h2>Configuring DashNex</h2>

<?php if ( $success ) { ?>
	<div class="alert alert-success dashnex-alert">
		<h4>DashNex Configuration Success</h4>
		<p>Congratulations.  DashNex has successfully been configured on your server.</p>
		<a href="" class="btn btn-success">Install</a>
	</div>
<?php } else { ?>
	<div class="alert alert-danger dashnex-alert">
		<h4>DashNex Configuration Failed</h4>
		<p>We attempted to configure DashNex automatically for you. Unfortunately it is not possible due to errors listed below. You can resolve this on your own by simply sending this email to your hosting provider.</p>
		<p>If you need some help, please do not hesitate to contact our awesome support via email support@pghelpdesk.com or just visit online http://pghelpdesk.com</p>
		<p>Once that's taken care of, simply come back to this page and we'll try again.</p>
	</div>
	
	<textarea class="dashnex-configure">Hi Support!

I'm trying to install and configure the DashNex Wordpress plugin and there are some errors which I need your help resolving.

Please can you configure the following -
<?php if ( ! $version_check ) { ?>
- Upgrade PHP version to at least 5.3.0
<?php } ?>

<?php if ( ! $datadir_check ) { ?>
- Make this directory writable by the server <?php echo $data_dir; ?>
<?php } ?>

<?php if ( ! $ioncube_check ) { ?>
- Install IonCube loader 4.4+ on the server (http://www.ioncube.com/loader_installation.php)
<?php } ?>

<?php if ( ! $curl_check ) { ?>
- Install the PHP Curl extension
<?php } ?>

<?php if ( ! $extension_check ) { ?>
- Install the json, PDO and pdo_msyql extensions on the server
<?php } ?>
Thank you!
	</textarea>
<?php } ?>

<h2>Results</h2>

<?php if ( $version_check ) { ?>
	<?php dashnex_render( 'version/success', array(
		'version' => $version
	)); ?>
<?php } else { ?>
	<?php dashnex_render( 'version/failure', array(
		'version' => $version
	)); ?>
<?php } ?>

<?php if ( $datadir_check ) { ?>
	<?php dashnex_render( 'cache/success', array(
		'data_dir' => $data_dir
	) ); ?>
<?php } else { ?>
	<?php dashnex_render( 'cache/failure', array(
		'data_dir' => $data_dir
	) ); ?>
<?php } ?>

<?php if ( $curl_check ) { ?>
	<?php dashnex_render( 'curl/success' ); ?>
<?php } else { ?>
	<?php dashnex_render( 'curl/failure' ); ?>
<?php } ?>

<?php if ( $ioncube_check ) { ?>
	<?php dashnex_render( 'ioncube/success' ); ?>
<?php } else { ?>
	<?php dashnex_render( 'ioncube/failure', array(
		'ioncube_version' => $ioncube_version
	)); ?>
<?php } ?>

<?php if ( $extension_check ) { ?>
	<?php dashnex_render( 'extensions/success' ); ?>
<?php } else { ?>
	<?php dashnex_render( 'extensions/failure' ); ?>
<?php } ?>

<?php if ( $mysql_permissions_check ) { ?>
    <?php dashnex_render( 'mysql/success' ); ?>
<?php } else { ?>
    <?php dashnex_render( 'mysql/failure' ); ?>
<?php } ?>
