<?php

/*
Plugin Name: DashNex Plugin
Plugin URI: http://www.dashnex.com
Description: DashNex brings you next generation plugins and themes right into your WP installation.
Version: 1.5.1
Author: PGP
Author URI: http://www.dashnex.com
*/

define('DASHNEX_DATABASE_VERSION', 78);
define('DASHNEX_DATABASE_META_KEY', '_dashnex_db_meta_key');

define('DASHNEX_FILE', __FILE__);
define('DASHNEX_PLUGIN_SLUG', 'dashnex-plugin/dashnex-plugin.php');
define('DASHNEX_APP_CODE', 'dashnex');
define('DASHNEX_DATA_DIR', WP_CONTENT_DIR . '/plugins/dashnex-data');
define('DASHNEX_CACHE_DIR', DASHNEX_DATA_DIR . "/cache");
define('DASHNEX_CONFIGURE_VIEW_DIR', dirname(__FILE__) . '/views/configure/');

define('DASHNEX_SITE_MANAGER_ACTIVE', true);

// This filter has to be in the main plugin file and the plugin file named after
// the directory that contains it or it won't work
add_filter('plugins_url', 'dashnex_plugins_url', 10, 3);

// Allow symlinking this plugin
function dashnex_plugins_url($url, $path, $plugin)
{
    // Do it only for this plugin
    if (strstr($plugin, 'dashnex-plugin')) {
        return str_replace(str_replace('\\', '/', dirname(__FILE__)), '/dashnex-plugin', $url);
    }

    return $url;
}

if (file_exists(DASHNEX_DATA_DIR . '/dashnex.php')) {
    require_once(DASHNEX_DATA_DIR . '/dashnex.php');
}

if (defined('DASHNEX_CONFIGURED')) {
    // we're configured and thus safe to use 5.3
    require_once(__DIR__ . '/dashnex-plugin-configured.php');
} else {
    // we're not configured so can't guarantee a 5.3 environment
    require_once(dirname(__FILE__) . '/dashnex-plugin-configure.php');
}
