
function getSiteManagerTree(action, caller) {
    var result;
    var id = caller.id;

    var getContentKeywords = function(id) {
        var keywords = [];
        jQuery.each(ActionCallersRegistry['content-keyword'], function(key, value){
            if (value && value.category_keyword_node_id && value.category_keyword_node_id == id){
                var keyword = ActionCallersRegistry['content-keyword'][key];

                var keywordData = {
                    id: keyword['id'],
                    caller_type: keyword['caller_type'],
                    keyword: keyword['keyword']
                };

                keywords.push(keywordData);
            }
        });
        return keywords;
    };

    var getCategoryKeywords = function() {
        var keywords = [];

        jQuery.each(ActionCallersRegistry['category-keyword'], function(key, keyword){
            if( ! keyword || keyword.parent_category_keyword) {
                return;
            }

            var keywordData = {
                id: keyword['id'],
                caller_type: keyword['caller_type'],
                keyword: keyword['keyword']
            };

            keywords.push(keywordData);
        });

        return keywords;
    };

    var getSubcategoryKeywords = function(parentId) {
        var keywords = [];
        jQuery.each(ActionCallersRegistry['category-keyword'], function(id, cat) {
            if(cat && cat.parent_category_keyword && cat.parent_category_keyword.id && cat.parent_category_keyword.id == parentId) {
                var keyword = ActionCallersRegistry['category-keyword'][id];

                var keywordData = {
                    id: keyword['id'],
                    caller_type: keyword['caller_type'],
                    keyword: keyword['keyword']
                };

                keywords.push(keywordData);
            }
        });

        return keywords;
    };

    switch (caller.caller_type) {
        case 'primary-keyword':
            result = ActionCallersRegistry['primary-keyword'];
            result.category_keywords = getCategoryKeywords();
            break;
        case 'category-keyword':
            jQuery.each(ActionCallersRegistry['category-keyword'], function (key, value) {
                if (value && value.id && value.id == id) {
                    result = ActionCallersRegistry['category-keyword'][key];
                    return false;
                }
            });

            result.child_category_keywords = getSubcategoryKeywords(result.id);
            result.content_keywords = getContentKeywords(result.id);

            break;
        case 'content-keyword':
            jQuery.each(ActionCallersRegistry['content-keyword'], function (key, value) {
                if (value && value.id && value.id == id) {
                    result = ActionCallersRegistry['content-keyword'][key];
                    return false;
                }
            });
            break;
    }
    return result;
}

function getCallerIndicatorsRegistry(action, caller) {
    caller = ActionCallerManager.GetCurrent(caller);
    result = caller.indicators;
    return result;
}