angular.module('dashnex', [])

    .config(['$interpolateProvider', '$httpProvider', function ($interpolateProvider, $httpProvider) {

        // setting [[ and ]] for Angular variables
        $interpolateProvider.startSymbol('[[').endSymbol(']]');

        // modifying request to make WP understand it
        $httpProvider.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded";
        $httpProvider.interceptors.push(function () {
            return {

                'request': function (config) {

                    if (typeof config.data == 'object') {
                        config.data = jQuery.param(config.data)
                    }

                    return config;
                }

            }
        })
    }]);

angular.element(document).ready(function () {
    angular.bootstrap(document, [
        'dashnex'
    ],{
        strictDi: true
    });
});