(function ($) {

    angular.module('dashnex')

        .controller('proxyController', ['$scope', 'proxyManager', '$http', '$filter', 'modal', function ($scope, proxyManager, $http, $filter, modal) {

            $scope.modal = modal;

            $scope.proxies = [];

            $scope.bulkList = '';
            $scope.requestInProgress = false;
            $scope.sectionToDelete = null;

            $scope.currentProxy = null;

            $scope.addOne = function () {
                if ($scope.currentProxy.ip && $scope.currentProxy.port) {
                    $scope.requestInProgress = true;
                    $scope.add($scope.currentProxy, function () {
                        $scope.requestInProgress = false;
                    })
                }
            };

            $scope.bulkAdd = function () {
                $scope.requestInProgress = true;

                var rows = $scope.bulkList.split("\n");

                if (rows.length > 0) {
                    $.each(rows, function (key, row) {

                        var values = row.split(':');

                        var proxy = {
                            ip: values[0] || '',
                            port: values[1] || '',
                            username: values[2] || '',
                            password: values[3] || ''
                        };

                        if (proxy.ip && proxy.port) {
                            if (rows.length - 1 != key) {
                                $scope.add(proxy);
                            } else {
                                // last element
                                $scope.add(proxy, function () {
                                    $scope.requestInProgress = false;
                                });
                            }
                        }
                    });
                }

                $scope.bulkList = '';
            };

            $scope.testAll = function (active) {
                var proxies = $filter('filter')($scope.proxies, {active: active});

                $.each(proxies, function (key, proxy) {
                    $scope.test(proxy)
                });
            };

            $scope.add = function (proxy, callBack) {

                proxyManager
                    .add(proxy)
                    .success(function (response) {

                        if (response.success) {
                            $scope.proxies.push(response.proxy);
                        } else {
                            //TODO: show error
                        }

                        if (callBack) {
                            callBack(response);
                        }
                    });
            };

            $scope.remove = function (proxyToRemove) {

                if ($scope.currentProxy) {
                    $scope.currentProxy.processing = true;
                }

                if (proxyToRemove || $scope.currentProxy) {
                    proxyManager
                        .remove(proxyToRemove || $scope.currentProxy)
                        .success(function (response) {

                            $.each($scope.proxies, function (index, proxy) {
                                if (typeof proxy == 'object' && proxy.id == response.id) {
                                    $scope.proxies.splice(index, 1)
                                }
                            });

                            if ($scope.currentProxy) {
                                $scope.currentProxy = null;
                            }
                        });
                }
            };

            $scope.test = function (proxy) {
                proxy.processing = true;

                proxyManager
                    .test(proxy)
                    .success(function (response) {

                        proxy.processing = false;
                        $scope.updateProxy(response.proxy);
                    });
            };

            $scope.removeAll = function () {

                if ($scope.sectionToDelete !== null) {
                    var proxies = $filter('filter')($scope.proxies, {active: $scope.sectionToDelete});

                    $.each(proxies, function (key, proxy) {
                        proxy.processing = true;
                        $scope.remove(proxy)
                    });
                }
            };

            $scope.updateProxy = function (newData) {
                $.each($scope.proxies, function (index, proxy) {
                    if (proxy.id == newData.id) {
                        $scope.proxies[index] = newData;
                    }
                })
            };

            $scope.showRemoveModal = function (proxy) {
                $scope.currentProxy = proxy;
                $scope.modal.show('#delete-modal');
            };

            $scope.showRemoveAllModal = function (active) {
                $scope.sectionToDelete = active;
                $scope.modal.show('#delete-all-modal');
            };
        }])

})(jQuery);