<?php

namespace DashNex\SiteManager\Model;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="dashnex_indicator", uniqueConstraints={@ORM\UniqueConstraint(name="dnc_caller_indicator", columns={"indicator_id", "caller_type", "caller_id"})})
 */
class Indicator {

	/**
	 * @ORM\Id
	 * @ORM\Column(type="integer")
	 * @ORM\GeneratedValue(strategy="AUTO")
	 */
	protected $id;

	/**
	 * @ORM\Column(type="string", length=64)
	 */
	protected $indicator_id;

	/**
	 * @ORM\Column(type="string", length=64)
	 */
	protected $caller_type;

	/**
	 * @ORM\Column(type="integer", nullable=true)
	 */
	protected $caller_id;

	public function __construct() {}

	public function GetId() {
		return $this->id;
	}

	public function SetId($id) {
		$this->id = $id;
		return $this;
	}

	public function GetIndicatorId() {
		return $this->indicator_id;
	}

	public function SetIndicatorId($id) {
		$this->indicator_id = $id;
		return $this;
	}

	public function GetCallerType() {
		return $this->caller_type;
	}

	public function SetCallerType($type) {
		$this->caller_type = $type;
		return $this;
	}

	public function GetCallerId() {
		return $this->caller_id;
	}

	public function SetCallerId($id) {
		$this->caller_id = $id;
		return $this;
	}

	public function GetDataArray() {
		$result = array(
			'id'			=> $this->GetId(),
			'indicator_id'	=> $this->GetIndicatorId(),
			'caller_type'	=> $this->GetCallerType(),
			'caller_id'		=> $this->GetCallerId()
		);

		return $result;
	}

	public function GetConfig() {
		global $dashnex_service_manager;
		if( ! $this->GetIndicatorId()) {
			return null;
		}

		return $dashnex_service_manager
			->getService('dashnex-indicator-manager')
			->GetIndicatorConfigById($this->GetIndicatorId());
	}
}