<?php

namespace DashNex\SiteManager\Model;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * @ORM\Entity
 * @ORM\Table(name="dashnex_category_keyword_node")
 * @ORM\HasLifecycleCallbacks
 */
class CategoryKeywordNode extends SMActionCaller
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(type="string",unique=true)
     */
    protected $keyword;

    /**
     * @ORM\Column(type="integer",nullable=true)
     */
    protected $wp_category_id;

    /**
     * @ORM\Column(type="integer",nullable=true)
     */
    protected $wp_page_id;

    /**
     * @ORM\ManyToOne(targetEntity="CategoryKeywordNode", inversedBy="child_category_keywords", cascade={"persist"})
     * @ORM\JoinColumn(name="parent_category_keyword_node_id", referencedColumnName="id", nullable=true, onDelete="CASCADE")
     */
    protected $parent_category_keyword;

    /**
     * @ORM\OneToMany(targetEntity="ContentKeywordNode",mappedBy="category_keyword", cascade={"remove"})
     */
    private $content_keywords;

    /**
     * @ORM\OneToMany(targetEntity="CategoryKeywordNode", mappedBy="parent_category_keyword", cascade={"remove"})
     */
    private $child_category_keywords;

    private $wp_category;
    private $wp_page;
    protected $silo_page_created;

    public function __construct()
    {
        $this->content_keywords = new ArrayCollection();
        $this->child_category_keywords = new ArrayCollection();
    }

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    public function getKeyword()
    {
        return $this->keyword;
    }

    public function setKeyword($keyword)
    {
        $this->keyword = $keyword;
        
        return $this;
    }

    public function getWPCategoryId()
    {
        return $this->wp_category_id;
    }
    
    public function setWPCategoryId($id)
    {
        $this->wp_category_id = $id;
        $this->wp_category = null;
    
        return $this;
    }

    public function getWPPageId()
    {
        return $this->wp_page_id;
    }

    public function setWPPageId($id)
    {
        $this->wp_page_id = $id;
        $this->wp_page = null;
    
        return $this;
    }

    public function getContentKeywords()
    {
        return $this->content_keywords;
    }

    public function setContentKeywords($keywords)
    {
        $this->content_keywords = $keywords;

        return $this;
    }

    public function getWPCategory($output = 'OBJECT')
    {
        if ($this->wp_category === null && $this->GetWPCategoryId() > 0) {
            $this->wp_category = get_category($this->GetWPCategoryId(), $output);
        } else if (!$this->GetWPCategoryId() && $this->wp_category) {
            $this->wp_category = null;
        }

        return $this->wp_category;
    }

    /**
     * @ORM\PreRemove
     */
    public function deleteIndicators()
    {
        global $dashnex_service_manager;
        $indicatorIds = $this->GetIndicators(true);
        $indicatorMgr = $dashnex_service_manager->getService('dashnex-indicator-manager');
        $indicatorMgr->Disable($indicatorIds, $this->GetCallerType(), $this->GetId(), true);
    }

    /**
     * @ORM\PostRemove
     */
    public function deleteWPCategory()
    {
        if (!$this->GetWPCategoryId()) {
            return true;
        }

        wp_delete_category($this->GetWPCategoryId());

        return true;
    }

    public function getWPPage($output = 'OBJECT')
    {
        if ($this->wp_page === null && $this->GetWPPageId() > 0) {
            $this->wp_page = get_post($this->GetWPPageId(), $output);
        } else if (!$this->GetWPPageId() && $this->wp_page) {
            $this->wp_page = null;
        }

        return $this->wp_page;
    }

    /**
     * @ORM\PostRemove
     */
    public function deleteWPPage()
    {
        if (!$this->GetWPPageId()) {
            return true;
        }

        wp_delete_post($this->GetWPPageId(), true);
        
        return true;
    }

    /**
     * @return \DashNex\SiteManager\Model\CategoryKeywordNode
     */
    public function getParentCategoryKeyword()
    {
        return $this->parent_category_keyword;
    }

    public function setParentCategoryKeyword($categoryKeyword)
    {
        if ($categoryKeyword instanceof self) {
            $this->parent_category_keyword = $categoryKeyword;
        }

        return $this;
    }

    public function getChildCategoryKeywords()
    {
        return $this->child_category_keywords;
    }

    public function setChildCategoryKeywords($categoryKeywords)
    {
        $this->child_category_keywords = $categoryKeywords;

        return $this;
    }

    public function setSiloPageCreated()
    {
        $this->silo_page_created = $this->wp_category_id && $this->wp_page_id ? true : false;
    }

    /**
     * @ORM\PostLoad
     */
    public function postLoad()
    {
        $this->SetSiloPageCreated();
    }

    /**
     * @ORM\PostPersist
     */
    public function postPersist()
    {
        $this->SetSiloPageCreated();
    }

    /**
     * @ORM\PostUpdate
     */
    public function postUpdate()
    {
        $this->SetSiloPageCreated();
    }

    // ActionCaller interface methods

    public function getCallerType()
    {
        return 'category-keyword';
    }
    
    // ActionCaller interface methods END
}
