<?php

namespace DashNex\SiteManager\Model;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="dashnex_bogus_node")
 */
class BogusNode extends SMActionCaller {

	/**
	 * @ORM\Id
	 * @ORM\Column(type="integer")
	 * @ORM\GeneratedValue(strategy="AUTO")
	 */
	protected $id;

	/**
	 * @ORM\Column(type="string",nullable=true)
	 */
	protected $label;

	/**
	 * @ORM\OneToOne(targetEntity="ContentKeywordNode", cascade={"remove"})
	 * @ORM\JoinColumn(name="content_keyword_node_id", referencedColumnName="id")
	 */
	protected $content_keyword;

	public function __construct() {}

	public function GetId() {
		return $this->id;
	}

	public function SetId($id) {
		$this->id = $id;
		return $this;
	}

	public function GetLabel() {
		return $this->label;
	}

	public function SetLabel($label) {
		$this->label = $label;
		return $this;
	}

	public function GetContentKeyword() {
		return $this->content_keyword;
	}

	public function SetContentKeyword($keywordNode) {
		if($keywordNode === null || $keywordNode instanceof ContentKeywordNode) {
			$this->content_keyword = $keywordNode;
		}
		return $this;
	}

	public function GetCallerType() {
		return 'bogus';
	}

}