<?php

namespace DashNex\Model;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="dashnex_proxy")
 */
class Proxy
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=16)
     */
    protected $ip;
    
    /**
     * @ORM\Column(type="integer")
     */
    protected $port;
    
    /**
     * @ORM\Column(type="string", length=64)
     */
    protected $username;
    
    /**
     * @ORM\Column(type="string", length=64)
     */
    protected $password;
    
    /**
     * @ORM\Column(type="boolean")
     */
    protected $active;
    
    /**
     * @ORM\Column(type="datetime")
     */
    protected $last_used;
    
    public function __construct()
    {
        $this->last_used = new \DateTime();
    }
    
    public function getId()
    {
        return $this->id;
    }
    
    public function getIp()
    {
        return $this->ip;
    }
    
    public function setIp($ip)
    {
        $this->ip = $ip;

        return $this;
    }
    
    public function getPort()
    {
        return $this->port;
    }
    
    public function setPort($port)
    {
        $this->port = $port;

        return $this;
    }
    
    public function getUsername()
    {
        return $this->username;
    }
    
    public function setUsername($username)
    {
        $this->username = $username;
        
        return $this;
    }

    public function getPassword()
    {
        return $this->password;
    }
    
    public function setPassword($password)
    {
        $this->password = $password;

        return $this;
    }
    
    public function isActive()
    {
        return $this->active;
    }
    
    public function setActive($active)
    {
        $this->active = $active;

        return $this;
    }
    
    public function getLastUsed()
    {
        return $this->last_used;
    }
    
    public function setLastUsed($last_used)
    {
        $this->last_used = $last_used;

        return $this;
    }

    public function toArray()
    {
        $vars = get_class_vars(__CLASS__);

        foreach ($vars as $name => $value) {
            $vars[$name] = $this->$name;
        }

        $vars['blocks'] = $this->getBlocks();

        return $vars;
    }

    public function isBlockedBy($serviceId)
    {
        if (!$serviceId) {
            return false;
        }

        global $dashnex_service_manager;

        return $dashnex_service_manager
            ->getService('dashnex-proxy-block-manager')
            ->isEnabled($this, $serviceId)
        ;
    }

    public function blockBy($serviceId)
    {
        if (!$serviceId) {
            return false;
        }

        global $dashnex_service_manager;

        return $dashnex_service_manager
            ->getService('dashnex-proxy-block-manager')
            ->enable($this, $serviceId)
        ;
    }

    public function unblockBy($serviceId)
    {
        if (!$serviceId) {
            return false;
        }

        global $dashnex_service_manager;

        return $dashnex_service_manager
            ->getService('dashnex-proxy-block-manager')
            ->disable($this, $serviceId)
        ;
    }

    public function getBlocks($returnObjects = false)
    {
        global $dashnex_service_manager;

        return $dashnex_service_manager
            ->getService('dashnex-proxy-block-manager')
            ->getBlocksByProxy($this, $returnObjects)
        ;
    }
}
