<?php

namespace DashNex\Model;

use Doctrine\ORM\Mapping AS ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="dashnex_license")
 */
class License {
	
	/**
	 * @ORM\Id
	 * @ORM\Column(type="integer")
	 * @ORM\GeneratedValue(strategy="AUTO")
	 */
	protected $id;
	
	/**
	 * @ORM\Column(type="string")
	 */
	protected $code;
	
	/**
	 * @ORM\Column(type="datetime")
	 */
	protected $valid_until;
	
	public function GetId() {
		return $this->id;
	}
	
	public function GetCode() {
		return $this->code;
	}
	
	public function SetCode( $code ) {
		$this->code = $code;
		return $this;
	}
	
	public function GetValidUntil() {
		return $this->valid_until;
	}
	
	public function SetValidUntil( $valid_until ) {
		$this->valid_until = $valid_until;
		return $this;
	}
	
	public function IsValid() {
		$now = new \DateTime();
		return $now < $this->valid_until;
	}
	
}
