<?php

namespace DashNex\Model;

use Doctrine\ORM\Mapping AS ORM;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * @ORM\Entity
 * @ORM\Table(name="dashnex_google_keyword_group")
 */
class GoogleKeywordGroup
{
	/**
	 * @ORM\Id
	 * @ORM\Column(type="integer")
	 * @ORM\GeneratedValue(strategy="AUTO")
	 */
	protected $id;
	
	/**
	 * @ORM\Column(type="string", length=255)
	 */
	protected $name;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    protected $competitionStrength;
	
	/**
	 * @ORM\OneToMany(targetEntity="GoogleKeyword", mappedBy="group",cascade={"remove"})
	 */
	protected $keywords;
	
	public function __construct() {
        $this->keywords = new ArrayCollection();
	}

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getKeywords()
    {
        return $this->keywords;
    }

    /**
     * @param mixed $keywords
     */
    public function setKeywords($keywords)
    {
        $this->keywords = $keywords;
        return $this;
    }

    public function addKeyword(GoogleKeyword $keyword) {
        $this->keywords[] = $keyword;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param mixed $name
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    public function toJsonObject() {

        $keywords = array();

        foreach($this->keywords as $keyword) {
            $keywords[$keyword->getId()] = $keyword->toJsonObject();
        }

        $object = new \stdClass();
        $object->id = $this->id;
        $object->name = $this->name;
        $object->keywords = $keywords;
        $object->competitionStrength = $this->competitionStrength;

        return $object;
    }

    /**
     * @return mixed
     */
    public function getCompetitionStrength()
    {
        return $this->competitionStrength;
    }

    /**
     * @param mixed $competitionStrength
     */
    public function setCompetitionStrength($competitionStrength)
    {
        $this->competitionStrength = $competitionStrength;
    }
	

}
